/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.thirdparty.cofhcore;

import cofh.core.init.CoreEnchantments;
import cofh.lib.capability.IEnchantableItem;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.api.item.ItemVolumeModifier;
import me.desht.pneumaticcraft.common.config.ConfigHelper;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.registries.ForgeRegistries;

public class HoldingEnchantableProvider
implements ICapabilityProvider {
    public static final Capability<IEnchantableItem> CAPABILITY_ENCHANTABLE_ITEM = CapabilityManager.get((CapabilityToken)new CapabilityToken<IEnchantableItem>(){});
    static Enchantment holdingEnchantment = null;
    private final AllowHoldingEnchant ench = new AllowHoldingEnchant();
    private final LazyOptional<IEnchantableItem> lazy = LazyOptional.of(() -> this.ench);

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        return CAPABILITY_ENCHANTABLE_ITEM.orEmpty(cap, this.lazy);
    }

    static void registerVolumeModifier() {
        holdingEnchantment = (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(new ResourceLocation("cofh_core", "holding"));
        if (holdingEnchantment != null) {
            PneumaticRegistry.getInstance().getItemRegistry().registerPneumaticVolumeModifier(new COFHVolumeModifier(holdingEnchantment));
        }
    }

    static void registerEnchantment() {
        CoreEnchantments.registerHoldingEnchantment();
    }

    public static class AllowHoldingEnchant
    implements IEnchantableItem {
        public boolean supportsEnchantment(Enchantment enchantment) {
            return (Double)ConfigHelper.common().integration.cofhHoldingMultiplier.get() > 0.0 && enchantment == holdingEnchantment;
        }
    }

    public record COFHVolumeModifier(Enchantment holding) implements ItemVolumeModifier
    {
        @Override
        public int getNewVolume(ItemStack stack, int oldVolume) {
            return oldVolume * (1 + EnchantmentHelper.m_44843_((Enchantment)this.holding, (ItemStack)stack));
        }

        @Override
        public void addInfo(ItemStack stack, List<Component> text) {
            int nHolding = EnchantmentHelper.m_44843_((Enchantment)this.holding, (ItemStack)stack);
            if (nHolding > 0) {
                text.add((Component)new TextComponent("\u25b6 ").m_7220_(this.holding.m_44700_(nHolding)));
            }
        }
    }
}

